package jadean.dean.java.resourceparser.classparser.cpinfo;
import java.io.DataInput;
import java.io.IOException;


public class CPInfoNameAndType extends CPInfo {

	private int nameIndex;
	private int descriptorIndex;

	public CPInfoNameAndType(DataInput di) {
		super(di);
		try {
			this.nameIndex = di.readUnsignedShort();
			this.descriptorIndex = di.readUnsignedShort();
		}
		catch (IOException e) {
		}		
	}

	@Override
	public String getData() {
		return this.nameIndex + " " + this.descriptorIndex;
	}

	public int getNameIndex() {
		return nameIndex;
	}

	public int getDescriptorIndex() {
		return descriptorIndex;
	}

}
